<?php

namespace TCG\Voyager\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class User extends Model 
{

    protected $table = 'users';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];
    protected $fillable = array('role_id', 'name', 'email', 'avatar', 'password', 'remember_token');
    protected $visible = array('role_id', 'name', 'email', 'avatar');

    public function role()
    {
        return $this->hasOne('Role');
    }

}